
GET FILE='E:\DEMO ANOVA DATA\BALANCED.SAV'.

* TWO WAY ANOVA - IS THERE AN INTERACTION BETWEEN TASK AND GROUP?

UNIANOVA
  score  BY task group
  /METHOD = SSTYPE(3)
  /INTERCEPT = INCLUDE
  /SAVE = PRED (PRE) ZRESID (ZRES)
  /CRITERIA = ALPHA(.05)
  /DESIGN = task group task*group .

* TEST HOMOGENEITY OF VARIANCE ASSUMPTION

IF (TASK EQ 1 AND GROUP EQ 1) TGP = 1.
IF (TASK EQ 2 AND GROUP EQ 1) TGP = 2.
IF (TASK EQ 3 AND GROUP EQ 1) TGP = 3.
IF (TASK EQ 4 AND GROUP EQ 1) TGP = 4.

IF (TASK EQ 1 AND GROUP EQ 2) TGP = 5.
IF (TASK EQ 2 AND GROUP EQ 2) TGP = 6.
IF (TASK EQ 3 AND GROUP EQ 2) TGP = 7.
IF (TASK EQ 4 AND GROUP EQ 2) TGP = 8.

IF (TASK EQ 1 AND GROUP EQ 3) TGP = 9.
IF (TASK EQ 2 AND GROUP EQ 3) TGP = 10.
IF (TASK EQ 3 AND GROUP EQ 3) TGP = 11.
IF (TASK EQ 4 AND GROUP EQ 3) TGP = 12.

EXE.

EXAMINE
  VARIABLES=score BY TGP
  /PLOT BOXPLOT STEMLEAF SPREADLEVEL
  /COMPARE GROUP
  /STATISTICS NONE
  /CINTERVAL 95
  /MISSING LISTWISE
  /NOTOTAL.


* CHECK RESIDUALS

GRAPH
  /SCATTERPLOT(BIVAR)=PRE WITH ZRES
  /MISSING=LISTWISE .

* CANNOT GET POST-HOC ADJUSTED T-TESTS OUT FOR INTERACTIONS BUT YOU
* CAN FOR MAIN EFFECTS

UNIANOVA
  score  BY task group
  /METHOD = SSTYPE(3)
  /INTERCEPT = INCLUDE
  /POSTHOC = task ( SIDAK )
  /CRITERIA = ALPHA(.05)
  /DESIGN = task group.

* SIMPLE EFFECTS: TASK DIFFERENCES IN EACH OF THE THREE GROUPS

MANOVA SCORE BY TASK(1,4) GROUP(1,3)
 /ERROR=WITHIN
 /DESIGN GROUP TASK WITHIN GROUP(1), TASK WITHIN GROUP(2), TASK WITHIN GROUP(3).



* SHOW GROUP MEANS TO AID INTERPRETATION OF 1 DF SUBSEQUENT TESTS


TEMPORARY.
SELECT IF (GROUP EQ 1).

MEANS
  TABLES=score  BY task
  /CELLS MEAN COUNT STDDEV  .

* USING SIMPLE CONTRASTS TO COMPARE TASK 2 (OBJECTS) WITH TASK 1 (ANIMALS)
* IN GROUP 1 (MILD PATIENTS) IE OBJECTS - ANIMALS SCORES

MANOVA SCORE BY TASK(1,4) GROUP(1,3)
 /ERROR=WITHIN
 /CONTRAST(TASK) = SIMPLE(1)
 /DESIGN GROUP TASK WITHIN GROUP(1).

* EQUIVALENTLY WE CAN DO THE FOLLOWING:
* NOTE THAT THE 'MISSING' PAIRWISE CONTRASTS ARE OBTAINED
* FROM THE GIVEN CONTRASTS E.G. (1 -1 0 0) - (1 0 -1 0) = 0 -1 1 0
* WHICH COMPARES GROUP 2 AND GROUP 3 HENCE THERE IS A UNIQUE SET
* OF RESULTS AND THE GIVEN SET OF CONTRASTS 'SPAN THE SPACE' OF ALL
* PAIRWISE CONTRASTS. SEE ALSO POST-HOC TALK.

MANOVA SCORE BY TASK(1,4) GROUP(1,3)
 /ERROR=WITHIN
 /CONTRAST(TASK) = SPECIAL(1 1 1 1 
                          1 -1 0 0 
                          1  0 -1 0 
                          1  0  0 -1) 
 /DESIGN=GROUP TASK WITHIN GROUP(1).


* HAVE A LOOK AT THE TASK SCORE MEANS IN MILD PATIENTS (GROUP 1)

TEMPORARY.
SELECT IF (GROUP EQ 1).

MEANS
  TABLES=score  BY task
  /CELLS MEAN COUNT STDDEV  .

T(I) = SCORE MEAN(TASK I IN GROUP 1) - SCORE MEAN (TASK 1 IN GROUP 1) / 
SQRT(2*(MS(ERROR OF FULL MODEL) / NUMBER OF REPLICATIONS))

E.G. PARAMETER T(2)

= (13 - 12.2) / SQRT(2 X 2.808/5) = 0.8/ 1.0598 = 0.75.

* ASSUMING INTERESTED IN ALL 6 POSSIBLE PAIRS OF TASK MEAN
* DIFFERENCES IN GROUP 1 = (4! / 2! 2! = 6)

* CAN CHANGE REFERENCE CATEGORY TO OBTAIN MISSING PAIRS.
* DIFFERENCE: ANIMALS - OBJECTS

MANOVA SCORE BY TASK(1,4) GROUP(1,3)
 /ERROR=WITHIN
 /CONTRAST(TASK) = SIMPLE(2)
 /DESIGN GROUP TASK WITHIN GROUP(1).

* CAN USE SIDAK TO CORRECT FOR MULTIPLE COMPARISONS: 6 POSSIBLE
* PAIRWISE DIFFERENCES INVOLVING FOUR GROUPS

COMPUTE SIDAK  = 1 - (1-0.001)**6.
EXE.


* WE CAN ALSO TEST SETS OF GROUPS WITH EACH OTHER

MANOVA SCORE BY TASK(1,4) GROUP(1,3)
 /ERROR=WITHIN
 /CONTRAST(TASK) = SPECIAL(1 1 1 1 
                          0.5 0.5 -0.5 -0.5 
                          -1 1 -1 1 
                          0.5 -0.5 -0.5 0.5) 
 /DESIGN=GROUP TASK WITHIN GROUP(1).

* CHECK THIS REPRESENTS TASK MEANS IN GROUP 1

*(E.G. 0.5, 0.5, -0.5, -0.5 REPRESENTS 
*(0.5 M1 + 0.5 M2 - 0.5 M3 - 0.5 M4).
*
*= FOR GROUP 1 THE ABOVE CONTRAST TESTS IF 
* 0.5 X 12.2 + 0.5 X 13 - 0.5 X 15 - 0.5 X 20 = -4.9
* DIFFERS FROM ZERO
* S.E. = (4 X 0.5 X 0.5) X SQRT(2.81/5) = 0.75

* USING 1 1 -1 -1 FOR THE SECOND TASK CONTRAST GIVES TWICE THE MEAN AND 
* STANDARD ERROR USING 0.5 0.5 -0.5 -0.5 AS ABOVE BUT THE SAME T VALUE
* WE GET -9.8 AND 1.50 WHICH ARE TWICE -4.9 AND 0.75

* YOU CAN ALSO PERFORM EACH CONTRAST SEPARATELY

TEMPORARY.
SELECT IF (GROUP EQ 1).

MEANS
  TABLES=score  BY task
  /CELLS MEAN COUNT STDDEV  .

* AN ALTERNATIVE APPROACH IN GLM:
* USING LMATRIX : SCORE MEAN IN TASK 2 - SCORE MEAN IN TASK 1 IN GROUP 1

GLM SCORE by TASK GROUP 
/METHOD = SSTYPE(3) 
/CRITERIA = ALPHA(.05) 
/LMATRIX TASK -1 1 0 0 TASK*GROUP -1 0 0 1 0 0 0 0 0 0 0 0             
/DESIGN TASK GROUP TASK*GROUP.

* IN ABOVE WE HAVE JUST DONE AN UNPAIRED T-TEST USING FULL MODEL MS(ERROR)
* DIFFERENCE IN MEANS = -12.2 + 13 = 0.8; S.E. = SQRT(2 X 2.81/5) = 1.06

* USING LMATRIX : SCORE MEAN IN TASK 3 - SCORE MEAN IN TASK 1 IN GROUP 1

GLM SCORE by TASK GROUP 
/METHOD = SSTYPE(3) 
/CRITERIA = ALPHA(.05) 
/LMATRIX TASK 1 0 -1 0 TASK*GROUP 1 0 0 0 0 0 -1 0 0 0 0 0             
/DESIGN TASK GROUP TASK*GROUP.

* FIRST TWO TASK MEANS (ANIMALS AND OBJECTS) MINUS LAST TWO TASK MEANS
* (PLANTS AND COUNTRIES) IN GROUP 1 (MILD PATIENTS)

GLM SCORE by TASK GROUP 
/METHOD = SSTYPE(3) 
/CRITERIA = ALPHA(.05) 
/LMATRIX TASK 1 1 -1 -1 TASK*GROUP 1 0 0 1 0 0 -1 0 0 -1 0 0             
/DESIGN TASK GROUP TASK*GROUP.

* ALTERNATIVELY USE 0.5 TO GET DIFFERENCE IN MEANS - T-TEST IDENTICAL
* TO ABOVE ONE

GLM SCORE by TASK GROUP 
/METHOD = SSTYPE(3) 
/CRITERIA = ALPHA(.05) 
/LMATRIX TASK 0.5 0.5 -0.5 -0.5 TASK*GROUP 0.5 0 0 0.5 0 0 -0.5 0 0 -0.5 0 0             
/DESIGN TASK GROUP TASK*GROUP.

* THREE WAY INTERACTIONS
* HAVE A LOOK AT THE MEANS

* NOTE WE NOW HAVE UNBALANCED DATA - DIFFERENT NUMBERS OF OBSERVATIONS
* FOR EACH TASK, GROUP, AGE GROUP COMBINATION SO I SPECIFY ALL THE
* SOURCES OF VARIATION IN THE /DESIGN SUBCOMMAND


TEMPORARY.
SELECT IF (COMBAGGP EQ 1).

MEANS
  TABLES=score  BY task
  /CELLS MEAN COUNT STDDEV  .

UNIANOVA
  score  BY task group agegp
  /METHOD = SSTYPE(3)
  /INTERCEPT = INCLUDE
  /SAVE = PRED (PRE) ZRESID (ZRES)
  /CRITERIA = ALPHA(.05)
  /DESIGN = task group agegp task*group group*agegp task*agegp task*group*agegp .

* IF THERE IS A THREE-WAY INTERACTION TEST TO SEE IF THERE ARE TWO-WAY
* INTERACTIONS IN EACH AGE GROUP

MANOVA SCORE BY TASK(1,4) GROUP(1,3) AGEGP(1,2)
 /ERROR=WITHIN
 /DESIGN TASK by GROUP WITHIN AGEGP(1),
         TASK by GROUP WITHIN AGEGP(2), TASK, GROUP, AGEGP, AGEGP*GROUP, AGEGP*TASK.


* CAN FURTHER SUBDIVIDE AND LOOK AT TASK SIMPLE EFFECTS IN COMBINATIONS
* OF GROUP AND AGE GROUP (KNOWN AS SIMPLE SIMPLE EFFECTS)

MANOVA SCORE BY TASK(1,4) GROUP(1,3) AGEGP(1,2)
 /DESIGN TASK WITHIN GROUP(1) WITHIN AGEGP(1), 
         TASK WITHIN GROUP(2) WITHIN AGEGP(1),
         TASK WITHIN GROUP(3) WITHIN AGEGP(1),
         TASK WITHIN GROUP(1) WITHIN AGEGP(2), 
         TASK WITHIN GROUP(2) WITHIN AGEGP(2),
         TASK WITHIN GROUP(3) WITHIN AGEGP(2), GROUP, AGEGP, GROUP*AGEGP.

* NOW LOOK AT TASK 3 - TASK 1 MEAN IN GROUP 1, AGE 1: ALL POSSIBLE
* COMBINATIONS CAN BE FITTED BUT WE HAVEN'T GOT THEM IN THIS DATA
* SO GET SOME REDUNDANCIES

MANOVA SCORE BY TASK(1,4) GROUP(1,3) AGEGP(1,2)
 /ERROR=WITHIN
 /CONTRAST(TASK)=SIMPLE(1)
 /DESIGN TASK WITHIN GROUP(1) WITHIN AGEGP(1), 
         TASK WITHIN GROUP(2) WITHIN AGEGP(1),
         TASK WITHIN GROUP(3) WITHIN AGEGP(1),   
         TASK WITHIN GROUP(1) WITHIN AGEGP(2),
         TASK WITHIN GROUP(2) WITHIN AGEGP(2),
         TASK WITHIN GROUP(3) WITHIN AGEGP(2), GROUP, AGEGP, GROUP*AGEGP.

* LOOK AT SIMPLE EFFECTS COMPARING TASK 1 (ANIMALS) WITH EACH OF THE OTHER
* TASKS IN GROUP 1 (MILD PATIENTS) WHO ARE YOUNG (AGEGP=1) 

MANOVA SCORE BY TASK(1,4) GROUP(1,3) AGEGP(1,2)
 /ERROR=WITHIN
 /CONTRAST(TASK)=SIMPLE(1)
 /DESIGN TASK WITHIN GROUP(1) WITHIN AGEGP(1), GROUP, AGEGP, GROUP*AGEGP.

* COMPARES TASK 1 (ANIMALS) WITH TASK 3 (PLANTS) IN GROUP 1 (MILD PATIENTS)
* WHO ARE YOUNG (AGEGP=1): DIFFERENCE IN MEANS = 12 -15.666 = -3.66
* USE CROSS PRODUCT OF FACTORS TO OBTAIN CONTRAST COEFFICIENTS

* http://imaging.mrc-cbu.cam.ac.uk/statswiki/FAQ/Interaction
* GIVES RATIONALE FOR WHAT TERMS TO PUT IN THE DESIGN STATEMENT
* SIMPLY INVOLVE ALL TERMS INVOLVING TASK - THE FACTOR WE ARE
* LOOKING AT DIFFERENCES OF AND IGNORE THE INTERACTION INVOLVING
* THE CONSTANT FACTORS: IN THIS CASE GROUP AND AGEGP
 
GLM SCORE by TASK GROUP AGEGP
/METHOD = SSTYPE(3) 
/CRITERIA = ALPHA(.05) 
/LMATRIX TASK 1 0 -1 0 TASK*GROUP 1 0 0 0 0 0 -1 0 0 0 0 0 
 TASK*AGEGP 1 0 0 0 -1 0 0 0 
 TASK*GROUP*AGEGP 1 0 0 0 0 0 0 0 0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 0           
/DESIGN TASK GROUP AGEGP TASK BY GROUP TASK BY AGEGP AGEGP BY GROUP TASK BY GROUP BY AGEGP.

* JUST AS WITH TWO-WAY INTERACTION:

* T = DIFFERENCE IN MEANS / S.E. USING POOLED MS(ERROR)
*  = (12 - 15.6667) / SQRT(2 X 3.366/3) = -3.667 / 1.498 = 2.45 

* THIS ALSO WORKS: TASK 1 MEAN - TASK 3 MEAN IN GROUP 1, AGE GP 1

GLM SCORE by TASK GROUP AGEGP
/METHOD = SSTYPE(3) 
/CRITERIA = ALPHA(.05) 
/LMATRIX TASK 1 0 -1 0 TASK*GROUP 1 0 0 0 0 0 -1 0 0 0 0 0 
 TASK*GROUP*AGEGP 1 0 0 0 0 0 0 0 0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 0           
/DESIGN TASK GROUP AGEGP GROUP BY AGEGP TASK*GROUP TASK*GROUP*AGEGP.

